<?php

/**
 * Product: sonnb - Stop Spam Here - BotScout API
 * Version: 1.0.0
 * Date: 11th Oct 2012
 * Author: sonnb
 * Website: www.sonnb.com - www.UnderWorldVN.com
 * License: You might not copy or redistribute this addon. 
 * *********Any action to public or redistribute must be authorized from author
 */
class sonnbStopSpamHere_Model_Botscout_Model_Botscout
{
    private static $timeout = 5;
    
    protected $api_key;
    protected $endpoint = 'http://botscout.com/test/';
    
    public function __construct($apiKey = null)
    {
        $this->api_key = $apiKey;
    }
    
    public function get($args)
    {
        $args['key'] = $this->api_key;
        
        $url = $this->endpoint . '?multi&' . http_build_query($args, '', '&');

        return $this->poll_json($url);
    }
    
    public function checkRegister($data)
    {
        try 
        {
            $records = $this->get($data);
            $spammer = array();
            
            $records = explode('|', $records);

            if (!in_array($records[0], array('Y')))
            {
                return false;
            }
            
            if (intval($records[3]) > 3)
            {
                $spammer['ip'] = array(
                    'ip' => $data['ip'] || '',
                    'reported' => $records[3]
                );
            }
            
            if (intval($records[5]) > 3)
            {
                $spammer['email'] = array(
                    'email' => $data['email'] || '',
                    'reported' => $records[5]
                );
            }
            
            if (intval($records[7]) > 3)
            {
                $spammer['username'] = array(
                    'username' => $data['email'] || '',
                    'reported' => $records[7]
                );
            }
            
            return $data;
        }
        catch (Exception $e)
        {
            return false;
        }
    }
    
    protected static function poll_json($url)
    {
        try
        {
            $ctx = stream_context_create(array(
                'http' => array(
                    'timeout' => self::$timeout
                )
                    )
            );

            $json = file_get_contents($url, false, $ctx);

            return $json;
        }
        catch (Exception $e)
        {
            return false;
        }
    }
}

?>
